//
//  MCSyncManagerProtocol.h
//  MCFoundation
//
//  Created by Ali Lalani on 09-08-24.
//  Copyright 2009 Marketcircle, Inc. All rights reserved.
//

#import "MCSyncWorkerProtocol.h"
#import "MCFileLogger.h"

// DO Proxy Protocol
@protocol MCSyncManagerProtocol <NSObject>

- (void)commitAllChanges;

- (oneway void)syncOperationCompleted: (BOOL)didSucceed exceptionReason: (NSString*)exceptionReason;

- (oneway void)setSyncWorker: (id <MCSyncWorkerProtocol>)aWorker;

- (oneway void)setActiveLogger: (MCFileLogger*)logger;

- (void)processChanges: (NSArray*)changes forSyncServicesEntityName: (NSString*)entityName;
- (void)commitQueuedChangesForSyncServicesEntityName: (NSString*)entityName;

#pragma mark Debug Logic
- (oneway void)debugPing;

@end

